/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.plant;

import com.badlogic.gdx.utils.IntMap;
import java.util.LinkedList;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetsBySpecies;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

public class PlantEntityAssetsByHeight {
    private IntMap<PlantEntityAssetsBySpecies> heightMap = new IntMap();
    private final PlantSpeciesDictionary speciesDictionary;

    public PlantEntityAssetsByHeight(PlantSpeciesDictionary speciesDictionary) {
        this.speciesDictionary = speciesDictionary;
    }

    public void add(PlantEntityAsset asset) {
        if (!this.heightMap.containsKey(asset.getTileHeight())) {
            this.heightMap.put(asset.getTileHeight(), new PlantEntityAssetsBySpecies(this.speciesDictionary));
        }
        this.heightMap.get(asset.getTileHeight()).add(asset);
    }

    public PlantEntityAsset get(PlantEntityAttributes attributes) {
        PlantEntityAssetsBySpecies bySpecies = this.heightMap.get(attributes.getCurrentTileHeight());
        if (bySpecies == null) {
            System.err.println("No plant assets for height: " + attributes.getCurrentTileHeight());
            return PlantEntityAssetsBySpecies.NULL_ENTITY_ASSET;
        }
        return bySpecies.get(attributes);
    }

    public List<PlantEntityAsset> getAll(PlantEntityAttributes attributes) {
        PlantEntityAssetsBySpecies bySpecies = this.heightMap.get(attributes.getCurrentTileHeight());
        if (bySpecies == null) {
            System.err.println("No list of plant assets for height: " + attributes.getCurrentTileHeight());
            return new LinkedList<PlantEntityAsset>();
        }
        return bySpecies.getAll(attributes);
    }
}

